/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.fs;

import com.zfabrik.components.provider.util.FSCRDBComponent;

/**
 * A root bound FSCRDBComponent. We only add some extra
 * information to bind the root the component was found in.
 */
public class RootBoundFSCRComponent extends FSCRDBComponent {
	private static final long serialVersionUID = 1L;
	private String root;

	public RootBoundFSCRComponent(RootBoundFSCRComponent c) {
		super(c);
	}

	public RootBoundFSCRComponent(String name) {
		super(name);
	}

	public void setRoot(String root) {
		this.root = root;
	}

	public String getRoot() {
		return root;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((root == null) ? 0 : root.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		RootBoundFSCRComponent other = (RootBoundFSCRComponent) obj;
		if (root == null) {
			if (other.root != null)
				return false;
		} else if (!root.equals(other.root))
			return false;
		return true;
	}
	
	public String toString() {
		return "{root:"+this.getRoot()+", super:"+super.toString()+"}";
	}

}
