/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components;

import java.util.List;

import com.zfabrik.resources.IResourceLookup;
import com.zfabrik.resources.IResourceManager;
import com.zfabrik.resources.TypeRef;


/**
 * The components lookup is a convenience wrapper of {@link IResourceLookup} 
 * for the for resource namespace <code>com.zfabrik.components</code>. When looking up components 
 * via this interface, the namespace will be prepended automatically.
 * In other words
 * <pre>
 * IComponentsLookup.INSTANCE.lookup(&lt;name&gt;,&lt;type&gt;) == IResourceLookup.INSTANCE.lookup(com.zfabrik.components/&lt;name&gt;,&lt;type&gt;)
 * </pre>
 * <p>
 * Some default resolutions apply for components when looking up for some type:
 * <ul>
 * <li>com.zfabrik.components.IComponentDescriptor.class: Returns the {@link IComponentDescriptor} for component</li>
 * </ul>
 */
public interface IComponentsLookup  {

	/**
	 * Resource namespace for component resources wihtin the resource management system.
	 */
	static final String    COMPONENTS = "com.zfabrik.components";
	
	/**
	 * Use as <code>IComponentsLookup.INSTANCE</code> to get the implementation of this interface. 
	 */
	static final IResourceLookup INSTANCE = initializer.get();
	
	/**
	 * Initialization help
	 */
	public static class initializer {
		private static IResourceLookup get() {
			return new IResourceLookup() {
				
				private IResourceLookup l() {
					IResourceLookup rl = IResourceManager.INSTANCE.lookup(COMPONENTS, IResourceLookup.class);
					if (rl==null) {
						throw new NullPointerException("Components Lookup not available");
					}
					return rl;
				}
				
				@Override
				public <T> T query(String resourceId, Class<T> clz) {
					return l().query(resourceId, clz);
				}
				
				@Override
				public <T> T query(String resourceId, TypeRef<T> typeRef) {
					return l().query(resourceId, typeRef);
				}
				
				@Override
				public <T> T lookup(String resourceId, Class<T> clz) {
					return l().lookup(resourceId, clz);
				}
				
				@Override
				public <T> T lookup(String resourceId, TypeRef<T> typeRef) {
					return l().lookup(resourceId, typeRef);
				}
				
				@Override
				public List<String> list() {
					return l().list();
				}
			};
		}
	}
}
