/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.util;


/**
 * Utility component descriptor implementation used by {@link FSComponentRepositoryDB}.
 *
 * @author hb
 *
 */
public class FSCRDBComponent extends AbstractComponentDescriptor  {
	private static final long serialVersionUID = FSComponentExtRepositoryDB.serialVersionUID;

	/**
	 * structural information. Both can be true. Needed to detect whether a change implies a component
	 * update by removing the properties file or the folder.
	 * Node: a folder defined component (z.properties) takes preference over a properties file
	 */
	private boolean hasFolder;
	private boolean hasFile;

	/**
	 * Indicates whether we already downloaded and verified all resources for this resource.
	 */
	transient private boolean resolved;


	public FSCRDBComponent(String name) {
		super.setName(name);
	}

	/**
	 * Copy constructor
	 * @param c {@link FSCRDBComponent} implementation to copy
	 */
	public FSCRDBComponent(FSCRDBComponent c) {
		super(c);
		this.hasFile = c.hasFile;
		this.hasFolder = c.hasFolder;
	}


	public void setHasFile(boolean hasFile) {
		this.hasFile = hasFile;
	}

	public void setHasFolder(boolean hasFolder) {
		this.hasFolder = hasFolder;
	}

	public boolean isHasFile() {
		return hasFile;
	}

	public boolean isHasFolder() {
		return hasFolder;
	}

	public void setResolved(boolean resolved) {
		this.resolved = resolved;
	}

	public boolean isResolved() {
		return resolved;
	}

	public String toString() {
		return "{name:"+this.getName()+", rev:"+this.getRevision()+", hasFile:"+hasFile+", hasFolder:"+hasFolder+", resolved:"+resolved+"}";
	}

	@Override
	public int hashCode() {
		return super.hashCode() ^ (Boolean.valueOf(hasFile).hashCode()) ^ (Boolean.valueOf(hasFolder).hashCode());
	}

	@Override
	public boolean equals(Object obj) {
		if (obj==this) {
			return true;
		}
		if (obj instanceof FSCRDBComponent) {
			FSCRDBComponent c = (FSCRDBComponent) obj;
			return super.equals(obj) && c.hasFile==this.hasFile && c.hasFolder==this.hasFolder;
		}
		return false;
	}
}
