/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.resources;

/**
 * A resource observer wraps a {@link IResourceHandle} with a weak reference, so that 
 * the observer is not a reason to keep resources in memory.  
 * 
 * @author hb
 *
 */
public interface IResourceObserver {
	
	/**
	 * Return a resource handle for the associated resource if still managed. Returns <code>null</code> otherwise. 
	 */
	IResourceHandle getHandle();
	
	/**
	 * Name of the resource with the resource management system
	 */
	String getName();
}
