/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

import com.zfabrik.util.logging.CompactFormatter;

public class SynchronizationLogHandler extends Handler {
	List<String> sb = new ArrayList<String>();
	CompactFormatter fm = new CompactFormatter();
	Thread th;

	public SynchronizationLogHandler() {}

	public void setThread(Thread t) {
		this.th = t;
	}

	public void publish(LogRecord record) {
		if (this.th.equals(Thread.currentThread())) {
			sb.add(fm.format(record));
		}
	}

	public void flush() {}

	public void close() throws SecurityException {}
	
	public void clear() {
		this.sb.clear();
	}

	public List<String> getLog() {
		return this.sb;
	}
}