/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.internal;

import java.util.Hashtable;

import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

/**
 * Previously the naming system integration with Z2 worked via registration of
 * an InitialContextFactoryBuilder and an ObjectFactoryBuilder directly with the 
 * Naming Manager. That can be done once only per life time of a VM and is 
 * hence not very embedding friendly.
 * Now we register only a convenient access to the Z2 naming system extension 
 * mechanism by allowing a lookup for a URLContextFactory and an InitialContextFactory 
 * as provided by naming extensions.
 * These lookups can be used by standard URL handlers etc to delegate to
 * Z2 provided extensions.
 */

public class NamingProvisioningHolder {
	public static NamingProvisioningHolder INSTANCE = new NamingProvisioningHolder();

	/**
	 * Interface registered by the Z2 hosted naming system implementation
	 */
	public interface NamingProvisioning {
		/**
		 * Find an InitialContextFactory given the name and env. Never returns null.
		 */
		InitialContextFactory findInitialContextFactory(String initCtxtFactoryName, Hashtable<?, ?> env) throws NamingException;
		/**
		 * Find a URL Context Factory for the schema and env. Never returns null.
		 */
		ObjectFactory findURLContextFactory(String scheme, Hashtable<?, ?> env) throws NamingException;
	}
	
	private NamingProvisioning naming;
	
	public void setNaming(NamingProvisioning naming) {
		this.naming = naming;
	}
	
	/**
	 * Never returns null.
	 */
	public NamingProvisioning getNaming() throws NamingException {
		return naming;
	}
		
	/**
	 * Find an InitialContextFactory given the name and env. Never returns null.
	 */
	public static InitialContextFactory findInitialContextFactory(String initCtxtFactoryName, Hashtable<?, ?> env) throws NamingException {
		return INSTANCE.getNaming().findInitialContextFactory(initCtxtFactoryName, env);
	}
	/**
	 * Find a URL Context Factory for the schema and env. Never returns null.
	 */
	public static ObjectFactory findURLContextFactory(String scheme, Hashtable<?, ?> env) throws NamingException {
		return INSTANCE.getNaming().findURLContextFactory(scheme, env);
	}
}
