/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;

import com.zfabrik.util.runtime.Foundation;

/**
 * A modification of the standard JUL file handler that suppresses logging
 * on worker nodes. In the server setup, this means that only the home process
 * will write log files (which is typically desirable, as it tunnels the worker
 * process logs anyway).
 * <p>
 * Can be used as a drop-in replacement for {@link FileHandler}
 * @author hb
 *
 */
public class HomeFileHandler extends FileHandler {

	public HomeFileHandler() throws IOException, SecurityException {
		super();
	}

	public HomeFileHandler(String pattern, boolean append) throws IOException, SecurityException {
		super(pattern, append);
	}

	public HomeFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
		super(pattern, limit, count, append);
	}

	public HomeFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
		super(pattern, limit, count);
	}

	public HomeFileHandler(String pattern) throws IOException, SecurityException {
		super(pattern);
	}
	
	@Override
	public synchronized void publish(LogRecord record) {
		if (Foundation.isWorker()) {
			return;
		}
		super.publish(record);
	}
	
}
