/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.sync;

import java.util.Set;

/**
 * Context interface passed on to {@link ISynchronizer} implementations during
 * synchronizations.
 * 
 * @author hb
 *
 */
public interface ISynchronization {

	/**
	 * gets the current set of invalid resources. During the pre-invalidation phase
	 * of the synchronization, synchronizers should add all resources
	 * that have become invalid
	 */
	Set<String> getInvalidationSet();
	
}
