/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.java;

import java.util.List;

import com.zfabrik.resources.IResourceHandle;

/**
 * Interface of the class loaders instantiated for Java components. 
 * @author hb
 *
 */
public interface IJavaComponentClassLoader {
	/**
	 * Get the name of the classloader that is useful for display
	 */
	String getName();
	
	/**
	 * Get the resource handle of the Java component, this loader belongs to.
	 */
	IResourceHandle getJavaComponentHandle();
	
	/**
	 * Get whether this loader is still in operation. After invalidation of a Java component
	 * for example because of a synchronization, its loader become unoperational and will
	 * not provide resources or classes anymore. 
	 */
	boolean isOperational();
	
	/**
	 * Get parent loaders
	 */
	List<ClassLoader> getParents();
	
}
