/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.java.build;

import java.io.File;
import java.util.logging.Logger;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IComponentsLookup;

/**
 * Interface to retrieve and invoke the java component make. This is used to decouple the low-level understanding of Java components
 * in z2 (which is needed so it can bootstrap) from the actual implementation that is in <code>com.zfabrik.boot.components.basic</code>
 */
public interface IJavaBuilder {
	
	/**
	 * Initialization help
	 */
	class Initializer {
		private static IJavaBuilder get() {
			IJavaBuilder ijb = IComponentsLookup.INSTANCE.lookup("com.zfabrik.boot.components.basic/componentsBuilder", IJavaBuilder.class);
			if (ijb==null) {
				throw new IllegalStateException("java builder not found!");
			}
			return ijb;
		}
	}

	IJavaBuilder INSTANCE = Initializer.get(); 
	
	/**
	 * Make a Java component. I.e. check whether it is up to date and if needed make sure that it gets build into componentFolder
	 * 
	 * @param cd
	 * @param originFolder Folder holding Java component resources as provided by the component repository
	 * @param instanceFolder Folder for instance specific resources. Origin resources will be copied and modified by compilation
	 * @param exLogger
	 */
	void make(IComponentDescriptor cd, File originFolder, File instanceFolder, Logger exLogger);
}
