/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.provider.props.Evaluator;

/**
 * This interface expresses the ability to process
 * properties of component descriptors.
 */
public interface IComponentDescriptorProcessor {

	/**
	 * Extension point ID for component descriptor processors. To be used in conjunction with
	 * {@link IComponentDescriptor#EXTENSION_POINTS}.
	 */
	final static String EXTENSION_POINT = "com.zfabrik.component.descriptorProcessor";

	/**
	 * Component property indicating what processing styles are implemented by the
	 * processor. See {@link IComponentDescriptor} for more details on the declaration of
	 * component property processing
	 */
	final static String STYLE_PROCESSED = "styles.processed";

	/**
	 * Provide an evaluator instance. The evaluator will be used during the processing of
	 * on component descriptor property map.
	 */
	Evaluator createEvaluator();

	
}
