/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider;

import com.zfabrik.components.IComponentsManager;

/**
 * The component repository context provides component repository implementations access to the repository chain.
 * Component repositories are organized in a chain of responsibility. Component repositories of higher priority ({@link IComponentsManager#registerRepository(int, IComponentsRepository)}
 * are required to handle visibility of components defined along the chain when implementing methods like {@link IComponentsRepository#findComponents(com.zfabrik.util.expression.X)}. 
 * 
 * @see IComponentsRepository
 * @author hb
 *
 */
public interface IComponentsRepositoryContext {
	
	/**
	 * Return the next, lower priority component repository or <code>null</code>, if this repository is 
	 * the end of the chain.
	 */
	IComponentsRepository next();
}
