/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.provider.props;

import java.util.Map;

/**
 * Processing context for a component descriptor processor provided evaluator
 */
public interface EvaluationContext {

	/**
	 * Resolve some property in the current resolution process
	 */
	Object get(String name) throws EvaluationException;

	/**
	 * Check if some property is defined (not necessarily evaluated yet)
	 */
	boolean has(String name);
	
	/**
	 * Access to the raw, unprocessed property set
	 */
	Map<Object,Object> getRawProperties();
	
}