/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.home.console;

/**
 * Statistics on the log buffer
 *
 */
public class LogBufferInfo {
	private int size;
	private int maxSize;
	private long expiration;
	private long linesHandled;

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public int getMaxSize() {
		return maxSize;
	}

	public void setMaxSize(int maxSize) {
		this.maxSize = maxSize;
	}

	public long getExpiration() {
		return expiration;
	}

	public void setExpiration(long expiration) {
		this.expiration = expiration;
	}

	public long getLinesHandled() {
		return linesHandled;
	}

	public void setLinesHandled(long linesHandled) {
		this.linesHandled = linesHandled;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (expiration ^ (expiration >>> 32));
		result = prime * result + (int) (linesHandled ^ (linesHandled >>> 32));
		result = prime * result + maxSize;
		result = prime * result + size;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LogBufferInfo other = (LogBufferInfo) obj;
		if (expiration != other.expiration)
			return false;
		if (linesHandled != other.linesHandled)
			return false;
		if (maxSize != other.maxSize)
			return false;
		if (size != other.size)
			return false;
		return true;
	}

}
