/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.home.console;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.resources.IResourceHandle;
import com.zfabrik.resources.IResourceInfo;
import com.zfabrik.resources.IResourceLookup;

public class TableHelper {
	private final static String[] REFTYPES = new String[] { "weak", "soft", "hard" };
	private final static int MAXCOL = 50;

	public static void printtable(String[] labels, String[][] rows) {
		int[] ls = new int[labels.length];
		for (int n = 0; n < rows.length; n++) {
			for (int m = 0; m < labels.length; m++) {
				if (rows[n][m] != null && rows[n][m].length() > ls[m]) {
					ls[m] = rows[n][m].length();
				}
			}
		}
		for (int m = 0; m < labels.length; m++) {
			if (labels[m].length() > ls[m]) {
				ls[m] = labels[m].length();
			}
			if (ls[m] > MAXCOL)
				ls[m] = MAXCOL;
		}
		String[] fs = new String[labels.length];
		for (int m = 0; m < labels.length; m++) {
			fs[m] = "|%-" + (ls[m] + 1) + "s";
		}
		for (int m = 0; m < labels.length; m++) {
			System.out.format(fs[m], labels[m]);
		}
		System.out.println();
		String s;
		for (int n = 0; n < rows.length; n++) {
			for (int m = 0; m < labels.length; m++) {
				s = rows[n][m];
				if (s != null && s.length() > MAXCOL) {
					s = "..." + s.substring(s.length() - MAXCOL + 3);
				}
				System.out.format(fs[m], s);
			}
			System.out.println();
		}
	}

	public static void printResourceList(IResourceLookup lookup) {
		Iterator<String> i = lookup.list().iterator();
		DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM);
		List<String[]> l = new ArrayList<String[]>(100);
		while (i.hasNext()) {
			IResourceHandle rh = lookup.lookup(i.next(), IResourceHandle.class);
			IResourceInfo ri = rh.getResourceInfo();
			IComponentDescriptor desc = rh.as(IComponentDescriptor.class);
			long exp = ri.getExpiration();
			l.add(new String[] { ri.getName(), (desc == null ? "n.a." : desc.getType()),
					(exp == Long.MAX_VALUE ? "never" : df.format(new Date(ri.getExpiration()))),
					Long.toString(ri.getTimeToLive()), REFTYPES[ri.getRefMode()] });
		}
		Collections.sort(l, new Comparator<String[]>() {
			public int compare(String[] o1, String[] o2) {
				return o1[0].compareTo(o2[0]);
			}

		});
		printtable(new String[] { "id", "type", "expiration", "timeToLive", "refType" }, l.toArray(new String[l.size()][3]));
	}

	public static void printprops(Properties p) {
		List<String[]> pl = new ArrayList<String[]>(p.size());
		for (Map.Entry<Object, Object> e : p.entrySet()) {
			pl.add(new String[] { (String) e.getKey(), (String) e.getValue() });
		}
		Collections.sort(pl, new Comparator<String[]>() {
			public int compare(String[] o1, String[] o2) {
				return o1[0].compareTo(o2[0]);
			}
		});
		String[][] t = new String[pl.size()][];
		pl.toArray(t);
		printtable(new String[] { "name", "value" }, t);
	}

}
