/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.resources.provider.Resource;
import com.zfabrik.resources.provider.IResourceProvider;
import com.zfabrik.resources.provider.IResourceProviderContext;

/**
 * the components provider is mostly a delegator to component type
 * specific provisioning. To do so, a component must specify a component
 * type and subsequently the component provider will search a component factory 
 * component by type that provides a corresponding resource representation.
 * <p>
 * Nevertheless, this provider provides the following interfaces:
 * <ul>
 * <li>{@link IComponentDescriptor}</li>
 * </ul>
 * 
 * @author hb
 *
 */

public class ComponentsProvider implements IResourceProvider {

	public Resource get(String name) {
		return new ComponentResourceWrapper(name);
	}

	public void init(IResourceProviderContext c) {
	}

}
