/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.work;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkerThread extends Thread {

	private final static Logger logger = Logger.getLogger(WorkerThread.class.getName());
	private static Field THREADLOCALS;

//  refs #1991, refs #1993: As Java 9 is harder on this kind of hack we removed it here and disabled pooling in the webdefault.xml  
//	static {
//		try {
//			for (Field f : Thread.class.getDeclaredFields()) {
//				if ("threadLocals".equals(f.getName())) {
//					THREADLOCALS = f;
//					THREADLOCALS.setAccessible(true);
//					break;
//				}
//			}
//			if (THREADLOCALS==null) {
//				logger.severe(
//						"This JDK's Thread implementation didn't give us the threadLocals field!\n"+
//						"Watch out for JASPERs use of PageContext pool (which is so stupid) and set org.apache.jasper.runtime.JspFactoryImpl.USE_POOL to false"
//				);
//			}
//		} catch (Exception e) {
//			logger.log(Level.SEVERE,"Error retrieving Thread.threadLocals field",e);
//		}
//	}
		
		
	private Runnable runnable;
	private ThreadPoolImpl threadpool;
	private WorkManagerImpl wm;
	private boolean waiting = false, kicked = false;

	public WorkerThread(String name, WorkManagerImpl wm, ThreadPoolImpl threadpool, Runnable runnable) {
		super(name);
		this.threadpool = threadpool;
		this.runnable = runnable;
		this.wm = wm;
		this.setDaemon(true);
	}

	@Override
	public void run() {
		while (this.runnable != null) {
			try {
				this.threadpool.doIt(this.runnable);
				// reset thread locals (another opportunity for leaks)
				if (THREADLOCALS!=null) {
					try {
						THREADLOCALS.set(this, null);
					} catch (Exception e) {
						logger.log(Level.SEVERE,"Error null'ing out Thread.threadLocals",e);
					}
				}
			} catch (Throwable t) {
				if (t instanceof VirtualMachineError) {
					logger.log(Level.SEVERE,"Caught "+t+" - committing suicide",t);
					System.exit(-1);
				}
				logger.log(Level.WARNING,"Exception during thread pool execution",t);
				
			} finally {
				this.runnable = null;
				// one job done.
				if (this.wm.taskCompleted(this)) {
					synchronized (this) {
						if (!this.kicked) {
							// only if not having been kicked between being put into
							// the pool and entering this block
							waiting = true;
							try {
								this.wait();
							} catch (InterruptedException e) {
								logger.fine("Thread interrupted: "+this);
							} finally {
								this.waiting = false;
							}
						} else
							this.kicked = false;
					}
				} else
					synchronized (this) {}  // also to comply to the memory model
			}
		}
	}

	protected synchronized void kick() {
		if (this.waiting)
			this.notify();
		else
			this.kicked = true;
	}

	protected synchronized void setRunnable(Runnable runnable) {
		this.runnable = runnable;
	}

	protected synchronized void setThreadpool(ThreadPoolImpl threadpool) {
		this.threadpool = threadpool;
	}

	protected synchronized ThreadPoolImpl getThreadpool() {
		return this.threadpool;
	}
	
}