/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.resources;

/**
 * Exception indicating that an invalidation was rejected by some 
 * dependency resource when attempting a friendly unload.
 * 
 * @see IResourceHandle#invalidate(boolean)
 *  
 */
public class ResourceBusyException extends RuntimeException {
	private static final long serialVersionUID = 1L;

	public ResourceBusyException() {
		super();
	}

	public ResourceBusyException(String message, Throwable cause) {
		super(message, cause);
	}

	public ResourceBusyException(String message) {
		super(message);
	}

	public ResourceBusyException(Throwable cause) {
		super(cause);
	}
	
	
}
