/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.resources.provider;

import com.zfabrik.resources.IResourceManager;


/**
 * Resource providers provide resources to the resource management system. When asked for a resource
 * the resource management will first check if an instance is already managed. If not it 
 * will look for a provider registered for the resource namespace.
 * <p>
 * Resource providers may be declared as component itself using the component type <code>com.zfabrik.resourceProvider</code>. 
 * <p>
 * For example the "components query provider" (<code>com.zfabrik.components/queryProvider</code>) is declared like this:
 * <pre>
 * com.zfabrik.component.type=com.zfabrik.resourceProvider
 * component.className=com.zfabrik.impl.components.query.QueryProvider
 * resourceProvider.namespace=com.zfabrik.components.query
 * </pre> 
 * 
 * 
 * @see IResourceManager#registerProvider(String, IResourceProvider)
 * @author hb
 *
 */
public interface IResourceProvider {
	String PROP_NAMESPACE 	= "resourceProvider.namespace";

	default void init(IResourceProviderContext c) {};

	/**
	 * retrieve a resource. Returns <code>null</code> if the resource does
	 * not exist (or will not be made available).
	 * Throws ResourceNotAvailableException if the resource cannot be provided due to an 
	 * error situation.

	 * @param name name of the resource
	 * @return the resource as a handle or <code>null</code> if the resource does
	 * not exist (or will not be made available).
	 * @throws ResourceNotAvailableException
	 */
	Resource get(String name);
}
