/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.function;

import java.util.function.Consumer;

/**
 * A consumer of a value that optionally throws an exception. 
 * 
 * Together with Java's type inference this interface is very useful
 * for many cases, where using {@link Consumer} would require extra handling of checked exceptions
 */
@FunctionalInterface
public interface ThrowingConsumer<T, E extends Exception> {

    /**
     * Accept a value
     *
     */
    void accept(T t) throws E;
}
