/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.function.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Some basic IO utilities
 */
public class IO {
	
	private IO() {}
	
	/**
	 * Read a stream fully
	 */
	public static byte[] readFully(InputStream in) throws IOException {
		ByteArrayOutputStream baOut = new ByteArrayOutputStream();
		byte[] b = new byte[4096];
		int l;
		while ((l=in.read(b))>0) baOut.write(b, 0, l);
		return baOut.toByteArray();
	}

}
