/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

import com.zfabrik.util.runtime.Foundation;

/**
 * @author hb
 *
 */
public class CompactFormatter extends Formatter
{
    private Calendar cal = Calendar.getInstance();
    private boolean showWorkerTime;
    
    
    public CompactFormatter() {
    	this.showWorkerTime = Boolean.valueOf(LogManager.getLogManager().getProperty(CompactFormatter.class.getName()+".showWorkerTime"));
	}

    public synchronized String format(LogRecord record)
    {
    	StringBuffer sb = new StringBuffer(200);
    	if (this.showWorkerTime || !Foundation.isWorker()) {
	    	// Minimize memory allocations here.
	    	cal.setTime(new Date(record.getMillis()));
	    	int h = cal.get(Calendar.MONTH)+1;
	    	if (h<10)
	    	    sb.append('0');
	    	sb.append(h);
	    	sb.append("/");
	    	h = cal.get(Calendar.DAY_OF_MONTH);
	    	if (h<10)
	    	    sb.append('0');
	    	sb.append(h);
	    	sb.append(" ");
	    	h = cal.get(Calendar.HOUR_OF_DAY);
	    	if (h<10)
	    	    sb.append('0');
	    	sb.append(h);
		    sb.append(':');
	    	h = cal.get(Calendar.MINUTE);
	    	if (h<10)
	    	    sb.append('0');
	    	sb.append(h);
		    sb.append(':');
	    	h = cal.get(Calendar.SECOND);
	    	if (h<10)
	    	    sb.append('0');
	    	sb.append(h);
		    sb.append(' ');
    	}
    	sb.append('[');
    	sb.append(Thread.currentThread().getId());
    	sb.append(']');
	    String ln = record.getLoggerName();
	    if (ln!=null) {
		    if (ln.length()>20) {
		        ln = "..."+ln.substring(ln.length()-17);
		    } else {
		    	sb.append("                    ".substring(0,20-ln.length()));
		    }
	    	sb.append(ln);
	    	sb.append(' ');
	    }
	    sb.append('[');
    	sb.append(record.getLevel().intValue());
	    sb.append(']');
	    sb.append(": ");
	    
	    Object[] ps = record.getParameters();
	    if (ps!=null && ps.length>0) {
	    	sb.append(MessageFormat.format(record.getMessage(),ps));
	    } else {
	    	sb.append(record.getMessage());
	    }
	    
    	if (record.getThrown() != null) {
    	    try {
    	        StringWriter sw = new StringWriter();
    	        PrintWriter pw = new PrintWriter(sw);
    	        record.getThrown().printStackTrace(pw);
    	        pw.close();
    	        sb.append("\n");
    	        sb.append(sw.toString());
    	    } catch (Exception ex) {
    	    }
    	}
        sb.append("\n");
        return sb.toString();
    }

}
