/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.logging;

/**
 * The JMX Log-Level MBean interface.
 *
 * The getters expose Log-Level counters as JMX attributes.
 * The {@code #reset} method is used to reset all counters via JMX
 */
public interface LogLevelMBean {

    /** returns the number of level FINEST log entries */
    int getLogFinest();

    /** returns the number of level FINER log entries */
    int getLogFiner();

    /** returns the number of level FINE log entries */
    int getLogFine();

    /** returns the number of level CONFIG log entries */
    int getLogConfig();

    /** returns the number of level INFO log entries */
    int getLogInfo();

    /** returns the number of level WARNING log entries */
    int getLogWarning();

    /** returns the number of level SEVERE log entries */
    int getLogSevere();

    /** resets all counters */
    void reset();
}
