/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.threading;

import java.util.Timer;
import java.util.concurrent.Callable;


/**
 * Use this utility to retrieve timers that hold no class loader<br> 
 * uncool: TimerThread will hold on to some context class loader that 
 *  may have become invalid in the meantime.
 * @author hb
 *
 */
public class TimerUtil {
	
	public static Timer createTimer() {
    	return createTimer(null,null);
	}
	
    public static Timer createTimer(boolean isDaemon) {
    	return createTimer(null,isDaemon);
    }

    public static Timer createTimer(String name) {
    	return createTimer(name,null);
    }

    public static Timer createTimer(String name, boolean isDaemon) {
    	return createTimer(name, (Boolean) isDaemon); 
    }

    private static Timer createTimer(final String name, final Boolean isDaemon) {
    	return ThreadUtil.cleanContextExecute(new Callable<Timer> () {
			public Timer call() {
		    	if (name==null) {
		    		if (isDaemon==null) {
		    			return new Timer();
		    		} else {
		    			return new Timer(isDaemon);
		    		}
		    	} else {
		    		if (isDaemon==null) {
		    			return new Timer(name);
		    		} else {
		    			return new Timer(name,isDaemon);
		    		}
		    	}
			}
		});
    }
	
}
