/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.eclipsoid.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IComponentsLookup;
import com.zfabrik.components.java.IJavaComponent;
import com.zfabrik.components.java.JavaComponentUtil;
import com.zfabrik.util.StringUtils;

public class ReferenceResolver extends HttpServlet {
	
	private static final long serialVersionUID = 1556165353726413635L;

	private List<String> projectNames;
	private PrintWriter w_out;

	public void setProjectName(String projectName) {
		this.projectNames = StringUtils.splitString(projectName);
		if (this.projectNames == null) {
			this.projectNames = Collections.emptyList();
		}
	}
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) {
		setProjectName(request.getParameter("projectName"));
		
		try  {
			response.setContentType("text/plain");
			response.setCharacterEncoding("UTF-8");
			this.w_out = response.getWriter();

			for (String project : projectNames) {
				generateReferencesFor(project);	
			}

		} catch (Exception e) {
			logger.log(Level.SEVERE,"Failed to resolve references of " + this.projectNames, e);
			e.printStackTrace();
			
			try {
				response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, 
						"Failed to resolve references of " + this.projectNames);
			} catch (IOException e1) {}
		}
		
	}

	private void generateReferencesFor(String projectName) throws IOException {
		Set<String> refs = new HashSet<String>();
		
		IComponentDescriptor desc = IComponentsLookup.INSTANCE.lookup(JavaComponentUtil.fixJavaComponentName(projectName), IComponentDescriptor.class);

		if (desc != null) {
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.PUBREFS),false);
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.PUBINCS),true);
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.PRIREFS),false);
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.PRIINCS),true);
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.TESTREFS),false);
            addRefs(refs,desc.getProperties().getProperty(IJavaComponent.TESTINCS),true);
			
			// add z-default dependency 
			refs.add("com.zfabrik.core.api/java");
		}
		
		w_out.print(projectName + " = ");
		w_out.print(refs.toString());
		w_out.println();
	}
	
	private void addRefs(Set<String> refs, String rp, boolean incl) {
		Collection<String> n = JavaComponentUtil.parseDependencies(rp);
		
		if (!incl) {
			// replay transitivity of refs
			for (String r : n) {
				if (refs.add(r)) {
					IComponentDescriptor desc = IComponentsLookup.INSTANCE.lookup(r,IComponentDescriptor.class);
					if (desc != null) {
						addRefs(refs,desc.getProperties().getProperty(IJavaComponent.PUBREFS),false);
					}
				}
			}
		} else {
			refs.addAll(n);
		}
	}

	private final static Logger logger = Logger.getLogger(ReferenceResolver.class.getName());
}
