/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * Callback handler for SVN LIST operation
 *
 */
public interface IDirEntryHandler {

	/**
 	 * This method is called for each SVN resource during an SVN LIST operation.
 	 * 
	 * @param entry
	 * 	contains information about a single dir entry (file or sub-directory)
	 * 
	 * @throws Exception
	 * 	the implementation will close all open streams and connections upon application exceptions 
	 *  (e.g. in order to reuse HTTP/TCP connections) 
	 */
	void handleSvnDirEntry(SvnDirEntry entry) throws Exception;
}
