/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * (c) by ZFabrik Software KG 2009,2010,2011,2012,2013,2014,2015
 * User: udoo
 * Date: 03.07.15
 * Time: 14:55
 */
public class SvnInfo extends SvnDirEntry {

    private final String rootUrl;
    private final String uuid;

    public SvnInfo(String rootUrl, String path, String crPath, long lastChangedRevision, NodeKind nodeKind, String uuid) {
        super(path, crPath, lastChangedRevision, nodeKind);
        this.rootUrl = rootUrl;
        this.uuid = uuid;
    }

    /**
     * @return
     *  SVN root URL - e.g: http://z2-environment.net/svn/z2-environment (never ends with "/")!
     */
    public String getRootUrl() {
        return rootUrl;
    }

    /**
     * @return
     *   SVN repository UUID
     */
    public String getUuid() {
        return uuid;
    }

	@Override
	public String toString() {
		return "SvnInfo [rootUrl=" + rootUrl + ", uuid=" + uuid
				+ ", super=" + super.toString() + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((rootUrl == null) ? 0 : rootUrl.hashCode());
		result = prime * result + ((uuid == null) ? 0 : uuid.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SvnInfo other = (SvnInfo) obj;
		if (rootUrl == null) {
			if (other.rootUrl != null)
				return false;
		} else if (!rootUrl.equals(other.rootUrl))
			return false;
		if (uuid == null) {
			if (other.uuid != null)
				return false;
		} else if (!uuid.equals(other.uuid))
			return false;
		return true;
	}

}
