/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.provider.resolver;

import com.zfabrik.resources.IResourceManager;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.IResourceProvider;
import com.zfabrik.resources.provider.IResourceProviderBuilder;
import com.zfabrik.resources.provider.IResourceProviderContext;
import com.zfabrik.resources.provider.Resource;

public class ProviderResolver extends Resource implements IResourceProviderBuilder,IResourceProvider {
	private final static String NS_PROVIDER = "com.zfabrik.resourceProviders";

	// resource
	@Override
	public synchronized void init() {
		IResourceManager.INSTANCE.registerProviderBuilder(this);
		IResourceManager.INSTANCE.registerProvider(NS_PROVIDER,this);
		
	}

	public synchronized void invalidate() throws ResourceBusyException {
		IResourceManager.INSTANCE.unregisterProvider(NS_PROVIDER,true);
		IResourceManager.INSTANCE.unregisterProviderBuilder(this);
	}

	// resource provider builder
	public IResourceProvider findProvider(String namespace) {
		return this.c.getNameSpace().lookup(namespace, IResourceProvider.class);
	}
	
	// resource provider (cache of queries)
	private IResourceProviderContext c;
	
	public void init(IResourceProviderContext c) {this.c=c;}
	
	public Resource get(String name) {
		return new ProviderResolution(name);
	}
}
