/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.svnaccess;


/**
 * Path helper methods
 */
public class PathHelper {

	/** 
	 * remove prefix path from path and remove trailing or leading slashes
	 */
	static String relativize(String uri, String baseUri) {
		if (uri!=null && baseUri!=null && uri.startsWith(baseUri)) {
			uri = uri.substring(baseUri.length());
		}
	    return deSlash(uri);
	}

	/**
	 * concatenate paths
	 */
	static String concat(String uri, String path) {
		return deSlashEnd(uri)+"/"+deSlashStart(path);
	}

	/**
	 * remove leading and tailing slashes
	 */
	public static String deSlash(String path) {
		return deSlashEnd(deSlashStart(path));
	}

	/**
	 * remove leading slashes
	 */
	public static String deSlashStart(String path) {
		if (path==null) {
			return null;
		}
		int p=0, l=path.length();
		while (p<l && path.charAt(p)=='/') p++;
		return path.substring(p);
	}

	/**
	 * remove trailing slashes
	 */
	public static String deSlashEnd(String path) {
		if (path==null) {
			return null;
		}
		int p=path.length();
		while (p>0 && path.charAt(p-1)=='/') p--;
		return path.substring(0,p);
	}


}
