/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.svncr;

import com.zfabrik.components.provider.util.FSComponentRepositoryDB;

/**
 * Extension holding further, SVN specific, repository metadata.
 * @author hb
 *
 */
public class ComponentRepositoryDB extends FSComponentRepositoryDB {
	private static final long serialVersionUID = 1L;

	public ComponentRepositoryDB() {
	}

	public ComponentRepositoryDB(long revision, String uuid) {
		super();
		this.revision = revision;
		this.uuid = uuid;
	}

	public ComponentRepositoryDB(ComponentRepositoryDB db) {
		super(db);
		this.revision=db.revision;
		this.uuid=db.uuid;
	}

	private long revision;
	private String uuid;

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}
	public String getUuid() {
		return uuid;
	}

	public long getRevision() {
		return this.revision;
	}

	public void setRevision(long revision) {
		this.revision = revision;
	}

	@Override
	public int hashCode() {
		return super.hashCode() ^ Long.valueOf(revision).hashCode();
	}
	@Override
	public boolean equals(Object obj) {
		if (obj==this) {
			return true;
		}
		if (obj instanceof ComponentRepositoryDB) {
			ComponentRepositoryDB d = (ComponentRepositoryDB) obj;
			return super.equals(obj) &&
					d.revision==this.revision &&
					((this.uuid==null && d.uuid==null) || (this.uuid!=null && this.uuid.equals(d.uuid)));
		}
		return false;
	}
}
