/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.svncr;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.zfabrik.svnaccess.IDirEntryHandler;
import com.zfabrik.svnaccess.IStreamHandler;
import com.zfabrik.svnaccess.ISvnLogEntryHandler;
import com.zfabrik.svnaccess.ISvnRepository;
import com.zfabrik.svnaccess.SvnInfo;
import com.zfabrik.work.IWorkResource;

public class SvnWorkResource implements IWorkResource {
	private final static Logger LOG = Logger.getLogger(SvnWorkResource.class.getName());
    private final ISvnRepository client;

    private SvnInfo info;

	public SvnWorkResource(ISvnRepository svnRepo) {
		this.client = svnRepo;
    }
	
	public void begin() {}
	public void beforeCompletion(boolean rollback){}
	public void afterCompletion(boolean rollback) {}

	public void close() {
		if (client!=null) {
			try {
				client.close();
			} catch (IOException e) {
				LOG.log(Level.WARNING, "Error during close of SVN client",e);
			}
		}
	}

	public void commit() {
	}
	public void rollback() {}

	public ISvnRepository getSVNRepository() {
		return this.client;
	}

    public String getSvnRootUrl() {
        return getRepoInfo().getRootUrl();
    }

    public String getBaseUrl() {
        return client.getBaseUrl();
    }

	public long getRepoRevision() {
		try {
			return client.getCurrentCRRevision();
		} catch (IOException e) {
			throw new RuntimeException("Current revision fetch of " + client.getBaseUrl() + " failed", e);		}
	}

    public String getRepositoryUuid() {
        return getRepoInfo().getUuid();
    }

    private SvnInfo getRepoInfo() {
        if (info == null) {
            try {
                info = client.info();
            } catch (IOException e) {
                throw new RuntimeException("svn info " + client.getBaseUrl() + "@HEAD failed", e);
            }
        }
        return info;
    }

    @Override
    public String toString() {
        return "SVNCR " + getBaseUrl() + "@" + getRepoRevision();
    }

    public void svnLog(String repoPath, long revStart, long revEnd, ISvnLogEntryHandler iSvnLogEntryHandler) throws IOException {
        this.client.log(repoPath, revEnd, revStart, revEnd, iSvnLogEntryHandler);
    }

    public SvnInfo svnInfo(String repoPath, long targetRevision) throws IOException {
        return this.client.info(repoPath, targetRevision);
    }

    public void svnCat(String repoPath, long targetRevision, IStreamHandler iStreamHandler) throws IOException {
        this.client.getContent(repoPath, targetRevision, targetRevision, iStreamHandler);
    }

    public int svnList(String repoPath, long targetRevision, IDirEntryHandler iDirEntryHandler) throws IOException {
        return this.client.list(repoPath, targetRevision, targetRevision, iDirEntryHandler);
    }

    public void svnExport(String repoPath, long targetRevision, File destFolder) throws IOException {
        this.client.export(repoPath, targetRevision, destFolder);
    }
}
