/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.files;

import com.zfabrik.components.java.IJavaComponent;


/**
 * Files component are nothing but containers for files that may be used by other components depending on their 
 * specific semantics.
 * 
 * See for example {@link IJavaComponent} for how to use Files components to implement packaging re-use of Java code.
 * 
 * Files components are declared using the component type <code>com.zfabrik.files</code> (see {@link #TYPE}). A component descriptor
 * of a Files component typically looks like this:
 * <pre>
 * com.zfabrik.component.type=com.zfabrik.files
 * </pre> 
 * 
 * @author hb
 *
 */
public interface IFilesComponent {
	/**
	 * Type identifier of a Files component. 
	 */
	String TYPE = "com.zfabrik.files";
}
