/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.compiler;

import static com.zfabrik.components.java.JavaComponentUtil.loadImplementationFromJavaComponent;
import static com.zfabrik.components.java.JavaComponentUtil.privateContextWrap;

import java.io.File;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.java.build.ICompilationContext;
import com.zfabrik.components.java.build.ICompiler;
import com.zfabrik.components.java.build.ICompilerContext;
import com.zfabrik.resources.IResourceHandle;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;

public class CompilerFactory extends Resource {

	private final String compName;
	private ICompiler compiler;
	
	public CompilerFactory(String name) {
		this.compName = name;
	}

	private static class CompilerContext implements ICompilerContext {
		private IResourceHandle handle;
		
		public CompilerContext(IResourceHandle handle) {
			this.handle = handle;
		}
		
		public IResourceHandle getHandle() {
			return handle;
		}
	}
	
	// just to attach the resource life cycle to the 
	// compiler instance handed out and to apply context switching
	private class C implements ICompiler {
		ICompiler c;
		C(ICompiler c) {
			this.c=c;
		}
		
		public void init(final ICompilerContext context) {
			c.init(context);
		}
		
		public boolean compile(String compName, File[] src, File dest, ClassLoader cl) {
			return c.compile(compName, src, dest, cl);
		}
		
		public boolean compile(ICompilationContext compilationContext) {
			return c.compile(compilationContext);
		}
	}
	
	@Override
	public <T> T as(Class<T> clz) {
		if (clz.equals(ICompiler.class)) {
			synchronized (this) {
				if (this.compiler == null) {
					this.compiler = new C(
						privateContextWrap(
							this.compName,
							loadImplementationFromJavaComponent(
								this.compName, 
								IComponentDescriptor.COMPONENT_CLZ, 
								handle(), 
								ICompiler.class
							),
							ICompiler.class
						)
					);
					this.compiler.init(new CompilerContext(handle()));
				}
				return clz.cast(this.compiler);
			}
		} else {
			throw new IllegalArgumentException("Compiler must implement " + ICompiler.class.getName());
		}
	}
	
	@Override
	public void invalidate() throws ResourceBusyException {
		synchronized (this) {
			if (this.compiler != null) {
				this.compiler = null;
			}
		}
	}
}
