/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.files;

import java.io.File;
import java.io.IOException;

import com.zfabrik.components.IComponentsManager;
import com.zfabrik.files.IFilesComponent;
import com.zfabrik.resources.provider.Resource;

/**
 * A files resource does just about nothing
 * @author hb
 *
 */
public class FilesResource extends Resource implements IFilesComponent {
	private String name;
	
	public FilesResource(String name) {	
		this.name = name;
	}
	
	public <T> T as(Class<T> clz) {
		if (IFilesComponent.class.equals(clz)) {
			return clz.cast(this); 
		}
		if (File.class.equals(clz)) {
			// important. Used from JavaComponentImpl
			try {
				return clz.cast(this.getRoot());
			} catch (IOException ioe) {
				throw new RuntimeException("Failed to retrieve files component root: "+this.name,ioe);
			}
		}
		return super.as(clz);
	}

	public File getRoot() throws IOException {
		return IComponentsManager.INSTANCE.retrieve(name);
	}	
}
