/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.java;

import java.io.File;

import com.zfabrik.components.java.IJavaComponent.Part;
import com.zfabrik.components.java.build.ICompilationContext;

/**
 * Simple impl of {@link ICompilationContext}.
 */
public class CompilationContextImpl implements ICompilationContext {
	
	/** The component name. */
	private File runtimeResources;

	/** The component name. */
	private String componentName;
	
	/** The source folders. */
	private File[] sourceFolders;
	
	/** The output folder. */
	private File outputFolder;
	
	/** The class path. */
	private ClassLoader classPath;
	
	/** The part. */
	private Part part;

	/**
	 * Instantiates a new compilation context impl.
	 *
	 * @param
	 * @param componentName the component name
	 * @param sourceFolders the source folders
	 * @param outputFolder the output folder
	 * @param classPath the class path
	 * @param part the part
	 */
	public CompilationContextImpl(String componentName, File runtimeResources, File[] sourceFolders, File outputFolder, ClassLoader classPath, Part part) {
		super();
		this.runtimeResources=runtimeResources;
		this.componentName = componentName;
		this.sourceFolders = sourceFolders;
		this.outputFolder = outputFolder;
		this.classPath = classPath;
		this.part = part;
	}
	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getComponentName()
	 */
	public String getComponentName() {
		return componentName;
	}
	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getRuntimeResources()
	 */
	public File getRuntimeResources() {
		return this.runtimeResources;
	}	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getSourceFolders()
	 */
	public File[] getSourceFolders() {
		return sourceFolders;
	}
	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getOutputFolder()
	 */
	public File getOutputFolder() {
		return outputFolder;
	}
	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getClassPath()
	 */
	public ClassLoader getClassPath() {
		return classPath;
	}
	
	/**
	 * @see com.zfabrik.components.java.build.ICompilationContext#getPart()
	 */
	public Part getPart() {
		return part;
	}
}
