/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.main;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.java.JavaComponentUtil;
import com.zfabrik.resources.IResourceHandle;
import com.zfabrik.resources.provider.Resource;

/**
 * Resource implementation for main programs that are to be executed using the MainRunner utility for 
 * embedded Z2 execution.
 * <p>
 * All a component needs to declare is the component type <code>com.zfabrik.mainProgram</code> and the class name of the component
 * implementing a main method.
 * <pre>
 * com.zfabrik.component.type=com.zfabrik.mainProgram
 * component.className=&lt;name of the main method class&gt;
 * </pre>
 * 
 * @author hb
 *
 */
public class MainProgramResource extends Resource {
	private String name;
	
	public MainProgramResource(String name) {
		this.name = name;
	}
	
	@Override
	public <T> T as(Class<T> clz) {
		if (Class.class.equals(clz)) {
			Class<?> clazz = JavaComponentUtil.loadImplementationClassFromJavaComponent(
				this.name, 
				IComponentDescriptor.COMPONENT_CLZ, 
				handle()
			);
			// keep!
			handle().adjust(0, Long.MAX_VALUE, IResourceHandle.STRONG);
			return clz.cast(clazz);
		}
		return null;
	}
}
