/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.resourceProvider;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IComponentsManager;
import com.zfabrik.components.java.JavaComponentUtil;
import com.zfabrik.resources.IResourceManager;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.IResourceProvider;
import com.zfabrik.resources.provider.IResourceProviderContext;
import com.zfabrik.resources.provider.Resource;

public class ProviderResource extends Resource {
	private PR pr;
	private String name;
	private String ns;

	public ProviderResource(String name) {
		this.name = name;
	}

	private class PR implements IResourceProvider {
		private IResourceProvider pr;

		public PR(IResourceProvider pr) {
			super();
			this.pr = pr;
		}

		public Resource get(String name) {
			return this.pr.get(name);
		}

		public void init(IResourceProviderContext c) {
			this.pr.init(c);
		}

	}

	public <T> T as(Class<T> clz) {
		synchronized (this) {
			if (this.pr == null) {
				IComponentDescriptor desc = IComponentsManager.INSTANCE
						.getComponent(this.name);
				if (desc == null) {
					throw new IllegalStateException(
							"Failed to retrieve component descriptor: "
									+ this.name);
				}
				this.ns = desc.getProperties().getProperty(IResourceProvider.PROP_NAMESPACE);
				if (ns == null) {
					throw new IllegalStateException(
							"Resource provider must specify namespace ("
									+ IResourceProvider.PROP_NAMESPACE + "): " + this.name);
				}
				PR p = new PR(JavaComponentUtil
						.loadImplementationFromJavaComponent(this.name,
								IComponentDescriptor.COMPONENT_CLZ, handle(), IResourceProvider.class));
				IResourceManager.INSTANCE.registerProvider(this.ns, p);
				this.pr = p;
			}
			return clz.cast(this.pr);
		}
	}

	@Override
	public void invalidate()
			throws ResourceBusyException {
		synchronized (this) {
			if (this.pr != null) {
				try {
					IResourceManager.INSTANCE.unregisterProvider(this.ns, true);
				} finally {
					this.pr = null;
				}
			}
		}
	}

}
