/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.components.synchronizer;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.java.JavaComponentUtil;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;
import com.zfabrik.util.sync.ISynchronization;
import com.zfabrik.util.sync.ISynchronizer;

public class SynchronizerResource extends Resource {
	private String name;
	private SY instance;

	private static class SY implements ISynchronizer {
		@SuppressWarnings("unused")
		private SynchronizerResource br;
		private ISynchronizer sy;

		public SY(SynchronizerResource br, ISynchronizer sy) {
			this.br = br;
			this.sy = sy;
		}

		public void complete(ISynchronization sync) {
			this.sy.complete(sync);
		}

		public void preInvalidation(ISynchronization sync) {
			this.sy.preInvalidation(sync);
		}
		
	}
	
	
	public SynchronizerResource(String name) {
		this.name = name;
	}

	public <T> T as(Class<T> clz) {
		synchronized (this) {
			if (ISynchronizer.class.equals(clz)) {
				if (this.instance==null) {
					ISynchronizer b = JavaComponentUtil.loadImplementationFromJavaComponent(
							this.name, IComponentDescriptor.COMPONENT_CLZ, handle(), ISynchronizer.class);
					this.instance = new SY(this,b);
				}
				return clz.cast(this.instance);
			}
		}
		return null;
	}


	@Override
	public void invalidate()
			throws ResourceBusyException {
		synchronized (this) {
			this.instance = null;
		}
	}

}
