/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.hubcr;

import com.zfabrik.components.provider.util.FSComponentRepositoryDB;

/**
 * The repository component DB for use with remote component repository
 * @author hb
 *
 */
public class RemoteComponentRepositoryDB extends FSComponentRepositoryDB {
	private static final long serialVersionUID = 1L;

	public RemoteComponentRepositoryDB() {	}

	/**
	 * Copy constructor
	 * @param db
	 */
	public RemoteComponentRepositoryDB(RemoteComponentRepositoryDB db) {
		super(db);
		this.revision = db.revision;
	}

	/**
	 * A revision of the whole db. This is used to
	 * check whether a new version needs to be distributed
	 * at all.
	 */
	private long revision;

	public long getRevision() {
		return revision;
	}

	public void setRevision(long revision) {
		this.revision = revision;
	}
}
