/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.components.java.internal;

import java.util.Set;

/**
 * Internal utility class. Provides really low-level 
 * methods for integration of foreign class loading systems - e.g. OSGI.
 * 
 * @author hb
 *
 */
public abstract class ClassLoaderIntegration {
	
	// NOTE: We track classloaders we run into during a retrieval to make sure
	// we don't go somewhere twice (and btw. this
	// renders cycles harmless)
	protected static ThreadLocal<Set<Object>> traversal = new ThreadLocal<Set<Object>>();

	/**
	 * Suspend traversal checking. Typically around defineClass calls that 
	 * initiate implicit class loading activities. Required to 
	 * make sure that Z class loader traversal optimization will not
	 * prohibit class loading that is logically independent
	 */
	public static Set<Object> suspendTraversalCheck() {
		try {
			return traversal.get();
		} finally {
			traversal.set(null);
		}
	}

	/**
	 * Attach traversal state again
	 */
	public static void attachTraversalCheck(Set<Object> t) {
		traversal.set(t);
	}
	
}
