/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.resources;

import com.zfabrik.resources.IResourceHandle;
import com.zfabrik.resources.IResourceLookup;
import com.zfabrik.resources.provider.Resource;
import com.zfabrik.resources.provider.IResourceProviderContext;

public class ResourceProviderContextImpl implements IResourceProviderContext {
	private NamespaceImpl ns;

	public ResourceProviderContextImpl(NamespaceImpl ns) {
		this.ns = ns;
	}

	public IResourceLookup getNameSpace() {
		return this.ns;
	}

	public IResourceHandle putResource(String name, Resource resource) {
		return this.ns.put(name,resource);
	}

}
