/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.work;

import java.util.concurrent.Callable;

/*
 * A runnable that organizes the execution of another runnable
 * by another thread
 */
public class QueuedExecutionGate implements Runnable {
	private final static short BLOCKED = 0;
	private final static short OPEN = 1;
	private final static short DONE = 2;
	
	private short status = BLOCKED;
	
	@Override
	public void run() {
		synchronized (this) {
			// open the gate
			this.status = OPEN;
			this.notifyAll();
			// wait until work completed
			while (this.status!=DONE) {
				try {
					this.wait();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}
		
	}
	
	public <T> T execute(Callable<T> callable) throws Exception {
		synchronized (this) {
			while (this.status==BLOCKED) {
				// if still blocked, wait until open
				try {
					this.wait();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		try {
			return callable.call();
		} finally {
			synchronized (this) {
				// indicate completion
				this.status=DONE;
				this.notify();
			}
		}
	}

	public void execute(final Runnable r) {
		try {
			execute(new Callable<Void>() {
				public Void call() throws Exception {
					r.run();
					return null;
				}
			});
		} catch (RuntimeException re) {
			throw re;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
