/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.work.jmx;

import java.util.Date;

import com.zfabrik.impl.work.ThreadPoolImpl;



public class ThreadPool implements ThreadPoolMBean
{
    private ThreadPoolImpl tp;
    
    public ThreadPool(ThreadPoolImpl tp)
    {
        this.tp = tp;
    }

    public int getConcurrency()   { return tp.conc; }
    public Date getLastResetTime() { return tp.lastReset;}
    public int getMaxConcurrencyAllowed() {  return tp.maxconc; }
    public int getMaxConcurrencyReached() { return tp.maxAchievedConcurrency; };
    public int getMaxQueueLength() { return tp.maxTaskQueueLength; };
    public Date getLastDispatch() { if (tp.lastDispatch>0) return new Date(tp.lastDispatch); else return null; };
    public int getQueueLength() { return tp.currentQueueLength; };
    public long getTasksCompleted() { return tp.tasksCompleted; }

    public void reset()
    {
        synchronized (tp)
        {
            tp.currentConcurrency = tp.conc;
            tp.maxAchievedConcurrency = tp.conc;
            tp.maxTaskQueueLength = tp.tasks.size();
            tp.currentQueueLength = tp.tasks.size();
            tp.lastReset=new Date();
            tp.tasksCompleted =0;
        }
    }

 
}
