/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.launch.impl;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.zfabrik.components.IComponentsLookup;
import com.zfabrik.util.runtime.Foundation;
import com.zfabrik.work.WorkUnit;

/**
 * Worker Process main class.. This class is the main entry point to worker
 * processes.
 * 
 * @author hb
 * 
 */
public class WorkerLauncher {
	private static final String WORKER_SOUL = "com.zfabrik.workers/workerSoul";


	public static void main(String[] args) throws Exception {
		// starting a worker is slightly different from starting
		// a home. 
		// We get into worker_up state and hand things over to 
		// the worker's soul
		String workerName = System.getProperty(Foundation.PROCESS_WORKER);
		if (workerName == null) {
			throw new IllegalStateException("Missing system property " + Foundation.PROCESS_WORKER);
		}
		Foundation.getProperties().setProperty(Foundation.PROCESS_WORKER, workerName);

		WorkUnit.initCurrent();
		// instantiate process master and initialize kernel, attain repos_up
		ProcessRunnerImpl.start();

		try {
			Runnable s = IComponentsLookup.INSTANCE.lookup(WORKER_SOUL, Runnable.class);
			if (s==null)
				throw new IllegalStateException("Failed to retrieve the worker's soul ("+WORKER_SOUL+")");
			s.run();
		} catch (Throwable e) {
			logger.log(Level.SEVERE, "Terminating because of error", e);
		} finally {
			logger.info("SHUTTING DOWN NOW");
			try {
				ProcessRunnerImpl.stop(); 
			} catch (Throwable t) {
				t.printStackTrace();
				System.exit(-1);
			}
		}
		System.err.println("GOOD BYE from worker " + workerName);
		System.exit(0);
	}

	public static final Logger logger = Logger.getLogger(WorkerLauncher.class.getName());
	public static final Logger perfLogger = Logger.getLogger("performance." + WorkerLauncher.class.getName());
}
