/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogLevelMBeanImpl implements LogLevelMBean {

    private int finestCount;
    private int finerCount;
    private int fineCount;
    private int configCount;
    private int infoCount;
    private int warningCount;
    private int severeCount;

    @Override
    public int getLogFinest() {
        return finestCount;
    }

    @Override
    public int getLogFiner() {
        return finerCount;
    }

    @Override
    public int getLogFine() {
        return fineCount;
    }

    @Override
    public int getLogConfig() {
        return configCount;
    }

    @Override
    public int getLogInfo() {
        return infoCount;
    }

    @Override
    public int getLogWarning() {
        return warningCount;
    }

    @Override
    public int getLogSevere() {
        return severeCount;
    }

    @Override
    public void reset() {
        finestCount = 0;
        finerCount = 0;
        fineCount = 0;
        configCount = 0;
        infoCount = 0;
        warningCount = 0;
        severeCount = 0;
    }

    void incLogLevel(LogRecord logRecord) {
        if (logRecord != null) {
            Level logLevel = logRecord.getLevel();
            if (Level.INFO.equals(logLevel)) {
                infoCount++;
            } else if (Level.WARNING.equals(logLevel)) {
                warningCount++;
            } else if (Level.SEVERE.equals(logLevel)) {
                severeCount++;
            } else if (Level.CONFIG.equals(logLevel)) {
                configCount++;
            } else if (Level.FINE.equals(logLevel)) {
                fineCount++;
            } else if (Level.FINER.equals(logLevel)) {
                finerCount++;
            } else if (Level.FINEST.equals(logLevel)) {
                finestCount++;
            }
        }
    }

    @Override
    public String toString() {
        return "LogLevelMBeanImpl{" +
               "finestCount=" + finestCount +
               ", finerCount=" + finerCount +
               ", fineCount=" + fineCount +
               ", configCount=" + configCount +
               ", infoCount=" + infoCount +
               ", warningCount=" + warningCount +
               ", severeCount=" + severeCount +
               '}';
    }
}
