/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.work;

/**
 * The work manager manages the system's concurrency.
 * 
 * @author hb
 *
 */
public abstract class WorkManager
{
    protected static WorkManager instance;

    public static WorkManager get()
    {
        if (instance==null)
            throw new IllegalStateException("work manager not initialized");
        return instance;
    }
    
    /**
     * provide a logical thread pool by id. Will throw an exception if a thread pool by the same id has been created
     * previously but released. 
     * @param id
     */
    public abstract IThreadPool createThreadPool(String id);
    
    /**
     * releases a named threadpool. Will throw an exception if the named threadpool does not exist or is 
     * still busy
     */
    public abstract void releaseThreadPool(String id);
    
  
}