/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.gcloud.session;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.ProjectionEntity;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Value;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.server.session.UnwriteableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class GCloudSessionDataStore
extends AbstractSessionDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(GCloudSessionDataStore.class);
    public static final int DEFAULT_MAX_QUERY_RESULTS = 100;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_BACKOFF_MS = 1000;
    protected Datastore _datastore;
    protected KeyFactory _keyFactory;
    protected int _maxResults = 100;
    protected int _maxRetries = 5;
    protected int _backoff = 1000;
    protected boolean _dsProvided = false;
    protected boolean _indexesPresent = false;
    protected EntityDataModel _model;
    protected boolean _modelProvided;
    private String _namespace;

    public void setEntityDataModel(EntityDataModel model) {
        this.updateBean(this._model, model);
        this._model = model;
        this._modelProvided = true;
    }

    public EntityDataModel getEntityDataModel() {
        return this._model;
    }

    public void setBackoffMs(int ms) {
        this._backoff = ms;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    @ManagedAttribute(value="gclound namespace", readonly=true)
    public String getNamespace() {
        return this._namespace;
    }

    @ManagedAttribute(value="unit in ms of exponential backoff")
    public int getBackoffMs() {
        return this._backoff;
    }

    public void setMaxRetries(int retries) {
        this._maxRetries = retries;
    }

    @ManagedAttribute(value="max number of retries for failed writes")
    public int getMaxRetries() {
        return this._maxRetries;
    }

    protected void doStart() throws Exception {
        if (!this._dsProvided) {
            this._datastore = !StringUtil.isBlank((String)this.getNamespace()) ? (Datastore)DatastoreOptions.newBuilder().setNamespace(this.getNamespace()).build().getService() : (Datastore)DatastoreOptions.getDefaultInstance().getService();
        }
        if (this._model == null) {
            this._model = new EntityDataModel();
            this.addBean(this._model, true);
        }
        this._keyFactory = (KeyFactory)this._datastore.newKeyFactory().setKind(this._model.getKind());
        this._indexesPresent = this.checkIndexes();
        if (!this._indexesPresent) {
            LOG.warn("Session indexes not uploaded, falling back to less efficient queries");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (!this._dsProvided) {
            this._datastore = null;
        }
        if (!this._modelProvided) {
            this._model = null;
        }
    }

    public void setDatastore(Datastore datastore) {
        this._datastore = datastore;
        this._dsProvided = true;
    }

    @ManagedAttribute(value="max number of results to return from gcloud searches")
    public int getMaxResults() {
        return this._maxResults;
    }

    public void setMaxResults(int maxResults) {
        this._maxResults = this._maxResults <= 0 ? 100 : maxResults;
    }

    public SessionData doLoad(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading session {} from DataStore", (Object)id);
        }
        try {
            Entity entity = this._datastore.get(this.makeKey(id, this._context));
            if (entity == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No session {} in DataStore ", (Object)id);
                }
                return null;
            }
            return this.sessionFromEntity(entity);
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing session {} from DataStore", (Object)id);
        }
        this._datastore.delete(new Key[]{this.makeKey(id, this._context)});
        return true;
    }

    public Set<String> doCheckExpired(Set<String> candidates, long time) {
        HashSet<String> expired = new HashSet<String>();
        try {
            Set<ExpiryInfo> info = null;
            info = this._indexesPresent ? this.queryExpiryByIndex(time) : this.queryExpiryByEntity(time);
            for (ExpiryInfo item : info) {
                if (StringUtil.isBlank((String)item.getLastNode()) || !this._context.getWorkerName().equals(item.getLastNode()) || StringUtil.isBlank((String)item.getContextPath()) || !this._context.getCanonicalContextPath().equals(item.getContextPath())) continue;
                expired.add(item.getId());
            }
            HashSet<String> tmp = new HashSet<String>(candidates);
            tmp.removeAll(expired);
            if (!tmp.isEmpty()) {
                for (String s : tmp) {
                    try {
                        KeyQuery q = ((KeyQuery.Builder)((KeyQuery.Builder)Query.newKeyQueryBuilder().setKind(this._model.getKind())).setFilter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)this._model.getId(), (String)s))).build();
                        QueryResults res = this._datastore.run((Query)q);
                        if (res.hasNext()) continue;
                        expired.add(s);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to expire candidate sessions individually", (Throwable)e);
                    }
                }
            }
            return expired;
        }
        catch (Exception e) {
            LOG.warn("Unable to get expired", (Throwable)e);
            return expired;
        }
    }

    public Set<String> doGetExpired(long time) {
        HashSet<String> expired = new HashSet<String>();
        try {
            Set<ExpiryInfo> info = null;
            info = this._indexesPresent ? this.queryExpiryByIndex(time) : this.queryExpiryByEntity(time);
            for (ExpiryInfo item : info) {
                expired.add(item.getId());
            }
            return expired;
        }
        catch (Exception e) {
            LOG.warn("Error querying expired sessions", (Throwable)e);
            return expired;
        }
    }

    public void doCleanOrphans(long timeLimit) {
        try {
            Set<ExpiryInfo> info = null;
            info = this._indexesPresent ? this.queryExpiryByIndex(timeLimit) : this.queryExpiryByEntity(timeLimit);
            Set<Key> keys = info.stream().map(i -> this.makeKey(i.getId(), i.getContextPath(), i.getVhost())).collect(Collectors.toSet());
            this._datastore.delete(keys.toArray(new Key[keys.size()]));
        }
        catch (Exception e) {
            LOG.warn("Error deleting orphaned sessions", (Throwable)e);
        }
    }

    protected Set<ExpiryInfo> queryExpiryByEntity() throws Exception {
        return this.queryExpiryByEntity(System.currentTimeMillis());
    }

    protected Set<ExpiryInfo> queryExpiryByEntity(long timeLimit) throws Exception {
        QueryResults results;
        HashSet<ExpiryInfo> infos = new HashSet<ExpiryInfo>();
        EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)((EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(this._model.getKind())).setFilter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.gt((String)this._model.getExpiry(), (long)0L), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.le((String)this._model.getExpiry(), (long)timeLimit)}))).setLimit(Integer.valueOf(this._maxResults))).build();
        if (LOG.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            results = this._datastore.run((Query)query);
            LOG.debug("Expiry query no index in {}ms", (Object)(System.currentTimeMillis() - start));
        } else {
            results = this._datastore.run((Query)query);
        }
        while (results.hasNext()) {
            Entity entity = (Entity)results.next();
            ExpiryInfo info = new ExpiryInfo(entity.getString(this._model.getId()), entity.getString(this._model.getLastNode()), entity.getLong(this._model.getExpiry()), entity.getString(this._model.getContextPath()), entity.getString(this._model.getVhost()));
            infos.add(info);
        }
        return infos;
    }

    protected Set<ExpiryInfo> queryExpiryByIndex() throws Exception {
        return this.queryExpiryByIndex(System.currentTimeMillis());
    }

    protected Set<ExpiryInfo> queryExpiryByIndex(long timeLimit) throws Exception {
        QueryResults presults;
        HashSet<ExpiryInfo> infos = new HashSet<ExpiryInfo>();
        ProjectionEntityQuery query = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.newProjectionEntityQueryBuilder().setKind(this._model.getKind())).setProjection(this._model.getId(), new String[]{this._model.getLastNode(), this._model.getExpiry(), this._model.getContextPath(), this._model.getVhost()}).setFilter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.gt((String)this._model.getExpiry(), (long)0L), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.le((String)this._model.getExpiry(), (long)timeLimit)}))).setLimit(Integer.valueOf(this._maxResults))).build();
        if (LOG.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            presults = this._datastore.run((Query)query);
            LOG.debug("Expiry query by index in {}ms", (Object)(System.currentTimeMillis() - start));
        } else {
            presults = this._datastore.run((Query)query);
        }
        while (presults.hasNext()) {
            ProjectionEntity pe = (ProjectionEntity)presults.next();
            ExpiryInfo info = new ExpiryInfo(pe.getString(this._model.getId()), pe.getString(this._model.getLastNode()), pe.getLong(this._model.getExpiry()), pe.getString(this._model.getContextPath()), pe.getString(this._model.getVhost()));
            infos.add(info);
        }
        return infos;
    }

    public boolean doExists(String id) throws Exception {
        QueryResults results;
        if (this._indexesPresent) {
            QueryResults presults;
            ProjectionEntityQuery query = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.newProjectionEntityQueryBuilder().setKind(this._model.getKind())).setProjection(this._model.getExpiry(), new String[0]).setFilter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)this._model.getId(), (String)id), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.eq((String)this._model.getContextPath(), (String)this._context.getCanonicalContextPath()), StructuredQuery.PropertyFilter.eq((String)this._model.getVhost(), (String)this._context.getVhost())}))).build();
            if (LOG.isDebugEnabled()) {
                long start = System.currentTimeMillis();
                presults = this._datastore.run((Query)query);
                LOG.debug("Exists query by index in {}ms", (Object)(System.currentTimeMillis() - start));
            } else {
                presults = this._datastore.run((Query)query);
            }
            if (presults.hasNext()) {
                ProjectionEntity pe = (ProjectionEntity)presults.next();
                return !this.isExpired(pe.getLong(this._model.getExpiry()));
            }
            return false;
        }
        EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)Query.newEntityQueryBuilder().setKind(this._model.getKind())).setFilter((StructuredQuery.Filter)StructuredQuery.CompositeFilter.and((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)this._model.getId(), (String)id), (StructuredQuery.Filter[])new StructuredQuery.Filter[]{StructuredQuery.PropertyFilter.eq((String)this._model.getContextPath(), (String)this._context.getCanonicalContextPath()), StructuredQuery.PropertyFilter.eq((String)this._model.getVhost(), (String)this._context.getVhost())}))).build();
        if (LOG.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            results = this._datastore.run((Query)query);
            LOG.debug("Exists query no index in {}ms", (Object)(System.currentTimeMillis() - start));
        } else {
            results = this._datastore.run((Query)query);
        }
        if (results.hasNext()) {
            Entity entity = (Entity)results.next();
            return !this.isExpired(entity.getLong(this._model.getExpiry()));
        }
        return false;
    }

    protected boolean isExpired(long timestamp) {
        if (timestamp <= 0L) {
            return false;
        }
        return timestamp < System.currentTimeMillis();
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing session {} to DataStore", (Object)data.getId());
        }
        Entity entity = this.entityFromSession(data, this.makeKey(id, this._context));
        int backoff = this.getBackoffMs();
        for (int attempts = 0; attempts < this.getMaxRetries(); ++attempts) {
            try {
                this._datastore.put((FullEntity)entity);
                return;
            }
            catch (DatastoreException e) {
                if (e.isRetryable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Datastore put retry=%s backoff=%s", attempts, backoff), (Throwable)e);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(backoff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    backoff *= 2;
                    continue;
                }
                throw e;
            }
        }
        throw new UnwriteableSessionDataException(id, this._context, null);
    }

    protected Key makeKey(String id, SessionContext context) {
        return this.makeKey(id, context.getCanonicalContextPath(), context.getVhost());
    }

    protected Key makeKey(String id, String canonicalContextPath, String canonicalVHost) {
        String key = canonicalContextPath + "_" + canonicalVHost + "_" + id;
        return this._keyFactory.newKey(key);
    }

    protected boolean checkIndexes() {
        try {
            ProjectionEntityQuery query = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.newProjectionEntityQueryBuilder().setKind(this._model.getKind())).setProjection(this._model.getExpiry(), new String[0]).setFilter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.eq((String)this._model.getId(), (String)"-"))).build();
            this._datastore.run((Query)query);
            return true;
        }
        catch (DatastoreException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check for indexes", (Throwable)e);
            }
            return false;
        }
    }

    protected Entity entityFromSession(SessionData session, Key key) throws Exception {
        if (session == null) {
            return null;
        }
        Entity entity = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Entity entity2;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                SessionData.serializeAttributes((SessionData)session, (ObjectOutputStream)oos);
                entity2 = entity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.newBuilder((Key)key).set(this._model.getId(), session.getId())).set(this._model.getContextPath(), session.getContextPath())).set(this._model.getVhost(), session.getVhost())).set(this._model.getAccessed(), session.getAccessed())).set(this._model.getLastAccessed(), session.getLastAccessed())).set(this._model.getCreateTime(), session.getCreated())).set(this._model.getCookieSetTime(), session.getCookieSet())).set(this._model.getLastNode(), session.getLastNode())).set(this._model.getExpiry(), session.getExpiry())).set(this._model.getMaxInactive(), session.getMaxInactiveMs())).set(this._model.getLastSaved(), session.getLastSaved())).set(this._model.getAttributes(), (Value)((BlobValue.Builder)BlobValue.newBuilder((Blob)Blob.copyFrom((byte[])baos.toByteArray())).setExcludeFromIndexes(true)).build())).build();
            }
            return entity2;
        }
    }

    protected SessionData sessionFromEntity(Entity entity) throws Exception {
        if (entity == null) {
            return null;
        }
        String id = entity.getString(this._model.getId());
        String contextPath = entity.getString(this._model.getContextPath());
        String vhost = entity.getString(this._model.getVhost());
        long accessed = entity.getLong(this._model.getAccessed());
        long lastAccessed = entity.getLong(this._model.getLastAccessed());
        long createTime = entity.getLong(this._model.getCreateTime());
        long cookieSet = entity.getLong(this._model.getCookieSetTime());
        String lastNode = entity.getString(this._model.getLastNode());
        long lastSaved = 0L;
        try {
            lastSaved = entity.getLong(this._model.getLastSaved());
        }
        catch (DatastoreException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
        long expiry = entity.getLong(this._model.getExpiry());
        long maxInactive = entity.getLong(this._model.getMaxInactive());
        Blob blob = entity.getBlob(this._model.getAttributes());
        SessionData session = this.newSessionData(id, createTime, accessed, lastAccessed, maxInactive);
        session.setLastNode(lastNode);
        session.setContextPath(contextPath);
        session.setVhost(vhost);
        session.setCookieSet(cookieSet);
        session.setLastNode(lastNode);
        session.setLastSaved(lastSaved);
        session.setExpiry(expiry);
        try (ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(blob.asInputStream());){
            SessionData.deserializeAttributes((SessionData)session, (ObjectInputStream)ois);
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
        return session;
    }

    @ManagedAttribute(value="does gcloud serialize session data", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[namespace=%s,backoff=%d,maxRetries=%d,maxResults=%d,indexes=%b]", super.toString(), this._namespace, this._backoff, this._maxRetries, this._maxResults, this._indexesPresent);
    }

    public static class ExpiryInfo {
        String _id;
        String _lastNode;
        String _contextPath;
        String _vhost;
        long _expiry;

        public ExpiryInfo(String id, String lastNode, long expiry, String contextPath, String vhost) {
            this._id = id;
            this._lastNode = lastNode;
            this._expiry = expiry;
            this._contextPath = contextPath;
            this._vhost = vhost;
        }

        public String getId() {
            return this._id;
        }

        public String getLastNode() {
            return this._lastNode;
        }

        public long getExpiry() {
            return this._expiry;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public void setContextPath(String contextPath) {
            this._contextPath = contextPath;
        }

        public String getVhost() {
            return this._vhost;
        }

        public void setVhost(String vhost) {
            this._vhost = vhost;
        }
    }

    public static class EntityDataModel {
        public static final String ID = "id";
        public static final String CONTEXTPATH = "contextPath";
        public static final String VHOST = "vhost";
        public static final String ACCESSED = "accessed";
        public static final String LASTACCESSED = "lastAccessed";
        public static final String CREATETIME = "createTime";
        public static final String COOKIESETTIME = "cookieSetTime";
        public static final String LASTNODE = "lastNode";
        public static final String EXPIRY = "expiry";
        public static final String MAXINACTIVE = "maxInactive";
        public static final String ATTRIBUTES = "attributes";
        public static final String LASTSAVED = "lastSaved";
        public static final String KIND = "GCloudSession";
        protected String _kind = "GCloudSession";
        protected String _id = "id";
        protected String _contextPath = "contextPath";
        protected String _vhost = "vhost";
        protected String _accessed = "accessed";
        protected String _lastAccessed = "lastAccessed";
        protected String _lastNode = "lastNode";
        protected String _lastSaved = "lastSaved";
        protected String _createTime = "createTime";
        protected String _cookieSetTime = "cookieSetTime";
        protected String _expiry = "expiry";
        protected String _maxInactive = "maxInactive";
        protected String _attributes = "attributes";

        private void checkNotNull(String s) {
            if (s == null) {
                throw new IllegalArgumentException(s);
            }
        }

        public String getLastNode() {
            return this._lastNode;
        }

        public void setLastNode(String lastNode) {
            this._lastNode = lastNode;
        }

        public String getKind() {
            return this._kind;
        }

        public void setKind(String kind) {
            this.checkNotNull(kind);
            this._kind = kind;
        }

        public String getId() {
            return this._id;
        }

        public void setId(String id) {
            this.checkNotNull(id);
            this._id = id;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public void setContextPath(String contextPath) {
            this.checkNotNull(contextPath);
            this._contextPath = contextPath;
        }

        public String getVhost() {
            return this._vhost;
        }

        public void setVhost(String vhost) {
            this.checkNotNull(vhost);
            this._vhost = vhost;
        }

        public String getAccessed() {
            return this._accessed;
        }

        public void setAccessed(String accessed) {
            this.checkNotNull(accessed);
            this._accessed = accessed;
        }

        public String getLastAccessed() {
            return this._lastAccessed;
        }

        public void setLastAccessed(String lastAccessed) {
            this.checkNotNull(lastAccessed);
            this._lastAccessed = lastAccessed;
        }

        public String getCreateTime() {
            return this._createTime;
        }

        public void setCreateTime(String createTime) {
            this.checkNotNull(createTime);
            this._createTime = createTime;
        }

        public String getCookieSetTime() {
            return this._cookieSetTime;
        }

        public void setCookieSetTime(String cookieSetTime) {
            this.checkNotNull(cookieSetTime);
            this._cookieSetTime = cookieSetTime;
        }

        public String getExpiry() {
            return this._expiry;
        }

        public void setExpiry(String expiry) {
            this.checkNotNull(expiry);
            this._expiry = expiry;
        }

        public String getMaxInactive() {
            return this._maxInactive;
        }

        public void setMaxInactive(String maxInactive) {
            this.checkNotNull(maxInactive);
            this._maxInactive = maxInactive;
        }

        public String getAttributes() {
            return this._attributes;
        }

        public void setAttributes(String attributes) {
            this.checkNotNull(attributes);
            this._attributes = attributes;
        }

        public String getLastSaved() {
            return this._lastSaved;
        }

        public void setLastSaved(String lastSaved) {
            this.checkNotNull(lastSaved);
            this._lastSaved = lastSaved;
        }

        public String toString() {
            return String.format("%s==%s:%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", this.getClass().getName(), this._kind, this._accessed, this._attributes, this._contextPath, this._cookieSetTime, this._createTime, this._expiry, this._id, this._lastAccessed, this._lastNode, this._maxInactive, this._vhost);
        }
    }
}

