/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.impl.svncr;

import com.zfabrik.components.IComponentDescriptor;
import com.zfabrik.components.IDependencyComponent;
import com.zfabrik.resources.ResourceBusyException;
import com.zfabrik.resources.provider.Resource;
import com.zfabrik.svnaccess.ISvnRepository;

/**
 * See {@link com.zfabrik.impl.svncr.ComponentRepositoryImpl}
 * @author hb
 *
 */
public class ComponentRepositoryResource extends Resource implements IDependencyComponent {
	private String name;
	// the actual repo
	private ComponentRepositoryImpl repo;
	// svn destination
	
	public ComponentRepositoryResource(String name) {
		this.name = name;
	}

	@Override
	public synchronized <T> T as(Class<T> clz) {
		if (ComponentRepositoryImpl.has(clz)) {
			_load();
			return this.repo.as(clz);
		}
		if (IDependencyComponent.class.equals(clz)) {
			return clz.cast(this);
		}
		if (ISvnRepository.class.equals(clz)) {
			return clz.cast(repo.getRepoSession().getSVNRepository());
		}
		return null;
	}
	
	@Override
	public synchronized void invalidate() throws ResourceBusyException {
		if (this.repo!=null) {
			try {
				this.repo.stop();
			} finally {
				this.repo = null;
			}
		}
	}

	@Override
	public synchronized void prepare() {
		_load();
	}

	private void _load() {
		if (this.repo==null) {
			this.repo = new ComponentRepositoryImpl(this.name, handle().as(IComponentDescriptor.class).getProperties());
			this.repo.start();
		}
	}


}
