/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * Callback handler for SVN LOG operation
 *
 */
public interface ISvnLogEntryHandler {

	/**
	 * This method is called for each SVN resource during an SVN LOG operation.
	 *
	 * @param logItem
	 * 	log item details like path, revision, action 
	 * 
	 * @throws Exception
	 * 	the implementation will close all open streams and connections upon application exceptions 
	 *  (e.g. in order to reuse HTTP/TCP connections) 
	 */
	void handleLogEntry(SvnLogItem logItem) throws Exception;
}
