/*
 * z2-Environment
 * 
 * Copyright(c) ZFabrik Software GmbH & Co. KG
 * 
 * contact@zfabrik.de
 * 
 * http://www.z2-environment.eu
 */
package com.zfabrik.svnaccess;

/**
 * Describes the kind of a {@link SvnDirEntry} or {@link SvnLogItem} -
 * so called a node. This can be one of
 * <ul>
 * <li><b>none</b>: 	information about the node-kind does not exist 
 * <li><b>file</b>: 	node is a file
 * <li><b>dir</b>:  	node is a directory
 * <li><b>unknown</b>   node kind is unknown
 * </ul>
 * The difference between <b>none</b> and <b>unknown</b> is that in the first case the information is
 * not provided by the server while in the latter case the server provides nodeKind="unknown".
 */
public enum NodeKind {
    none, file, dir, unknown;
}
